﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SWAT_Office_App
{
    public partial class DriveLogger_LabelPrompt_Form : Form
    {
        // Default values to return on query
        public string driveOwner = "Unknown";
        public string driveDock = "Unspecified";
        // RadioButton list for holding list of docks as specified in settings.xml
        private List<RadioButton> rdoBtnList= new List<RadioButton>();

        public DriveLogger_LabelPrompt_Form()
        {
            InitializeComponent();
            this.KeyPreview = true;
            this.btn_Ok.Enabled = false;
            // Location markers for the next radiobutton plcaement
            int nextXLocation = 6, nextYLocation = 19;
            // Sets groupbox and window size depending on number of radiobuttons
            this.groupBox_Dock.Size = new Size(118, 19 + (Settings_Form.driveLoggerDockLabels.Count) * 23);
            this.Size = new Size(148, 126 + (Settings_Form.driveLoggerDockLabels.Count) * 23);
            // Adds a radiobutton for each dock
            foreach (string str in Settings_Form.driveLoggerDockLabels)
            {
                RadioButton newRdoBtn = new RadioButton();
                newRdoBtn.Name = "rdo_" + str;
                newRdoBtn.TabStop = true;
                newRdoBtn.AutoSize = true;
                newRdoBtn.Text = str;
                newRdoBtn.Location = new Point(nextXLocation, nextYLocation);
                nextYLocation += 23;
                // Adds the radiobutton to the groupbox and rdoBtnList
                groupBox_Dock.Controls.Add(newRdoBtn);
                rdoBtnList.Add(newRdoBtn);
            }
            this.txt_Owner.TextChanged += new EventHandler(txt_Owner_TextChanged);
        }
        void txt_Owner_TextChanged(object sender, EventArgs e)
        {
            // Enables the Ok button if text is entered
            if (txt_Owner.TextLength > 0)
                this.btn_Ok.Enabled = true;
            else
                this.btn_Ok.Enabled = false;
        }
        private void btn_Ok_Click(object sender, EventArgs e)
        {
            // Updates variables and closes form
            driveOwner = txt_Owner.Text;
            foreach (RadioButton btn in rdoBtnList)
            {
                if (btn.Checked)
                    driveDock = btn.Text;
            }
            this.Close();
        }
    }
}
